//**********************************************************
//* divfuncs.h
//*
//* (c) Code Red Technologies, 2010
//*
//* This header files provides a means of accessing the
//* divide library routines stored in the ROM of
//* an appropriate NXP LPC1xxx MCU.
//**********************************************************

#ifndef DIVFUNCS_H_
#define DIVFUNCS_H_

#include <stdint.h>

typedef struct
{
       uint32_t div;
       uint32_t mod;
} udiv_t;

typedef struct
{
       int32_t div;
       int32_t mod;
} sdiv_t;

int32_t sdiv (int32_t, int32_t);
uint32_t udiv (int32_t, int32_t);
sdiv_t sdivmod (int32_t, int32_t);
udiv_t udivmod (uint32_t, uint32_t);

#endif
